<?php
/**
 * Ajax actions file.
 *
 * @package PLAYER\Public\Ajax
 */

/**
 * Replace iframes by WPS PLAYER.
 *
 * @since 1.0.0
 *
 * @return void Return json array with new_content equals to {string video_tag if success || string empty if not}.
 */
function ctpl_load_player() {
	check_ajax_referer( 'ajax-nonce', 'nonce', false );
	$video_tag = '';
	if ( isset( $_POST['iframe_index'], $_POST['iframe_tag'] ) ) {
		$iframe_index = intval( $_POST['iframe_index'] );
		$iframe_tag   = wp_kses(
			wp_unslash( $_POST['iframe_tag'] ),
			array(
				'iframe' => array(
					'align'           => true,
					'allowfullscreen' => true,
					'class'           => true,
					'data-*'          => true,
					'frameborder'     => true,
					'height'          => true,
					'id'              => true,
					'marginheight'    => true,
					'marginwidth'     => true,
					'name'            => true,
					'sandbox'         => true,
					'scrolling'       => true,
					'src'             => true,
					'style'           => true,
					'width'           => true,
				),
			)
		);
		$video_tag    = CTPL()->replace_iframe( $iframe_tag, $iframe_index );
	}
	wp_send_json( array( 'new_content' => $video_tag ) );
	wp_die();
}
