<?php
/**
 * Dynamic CSS Style plugin file.
 *
 * @package PLAYER\Dynamic-style
 */

$main_color   = xbox_get_field_value( 'ctpl-options', 'main-color' );
$is_wps_theme = CTPL()->is_wps_theme();

if ( ! function_exists( 'ctpl_get_brightness' ) ) {
	/**
	 * Detect brightness of $hex color and return $light_color or $dark_color.
	 *
	 * @param string $hex         The hex color ({#}xxx{xxx}).
	 * @param string $light_color The hex light color ({#}xxx{xxx}).
	 * @param string $dark_color  The hex dark color ({#}xxx{xxx}).
	 *
	 * return string $light_color or $dark_color.
	 */
	function ctpl_get_brightness( $hex, $light_color, $dark_color ) {
		$hex = str_replace( '#', '', $hex );
		$c_r = hexdec( substr( $hex, 0, 2 ) );
		$c_g = hexdec( substr( $hex, 2, 2 ) );
		$c_b = hexdec( substr( $hex, 4, 2 ) );
		return ( ( $c_r * 299 ) + ( $c_g * 587 ) + ( $c_b * 114 ) ) / 1000 > 180 ? $dark_color : $light_color;
	}
}
?>

<style>
	.wps-player__happy-inside-btn-close {
		background-color: <?php echo esc_html( $main_color ); ?>;
		color: <?php echo esc_html( ctpl_get_brightness( $main_color, '#fff', '#000' ) ); ?>;
	}

	.wps-player__happy-inside-btn-close {
		border-color: <?php echo esc_html( $main_color ); ?>!important;
		color: <?php echo esc_html( ctpl_get_brightness( $main_color, '#fff', '#000' ) ); ?>;
	}

	.fluid_initial_play:hover {
		-webkit-box-shadow: 0px 0px 40px 5px <?php echo esc_html( $main_color ); ?>;  /* Safari 3-4, iOS 4.0.2 - 4.2, Android 2.3+ */
		-moz-box-shadow:    0px 0px 40px 5px <?php echo esc_html( $main_color ); ?>;  /* Firefox 3.5 - 3.6 */
		box-shadow:         0px 0px 40px 5px <?php echo esc_html( $main_color ); ?>;  /* Opera 10.5, IE 9, Firefox 4+, Chrome 6+, iOS 5 */
	}

	@keyframes lds-double-ring {
	0% {
		-webkit-transform: rotate(0);
		transform: rotate(0);
	}
	100% {
		-webkit-transform: rotate(360deg);
		transform: rotate(360deg);
	}
	}
	@-webkit-keyframes lds-double-ring {
	0% {
		-webkit-transform: rotate(0);
		transform: rotate(0);
	}
	100% {
		-webkit-transform: rotate(360deg);
		transform: rotate(360deg);
	}
	}
	@keyframes lds-double-ring_reverse {
	0% {
		-webkit-transform: rotate(0);
		transform: rotate(0);
	}
	100% {
		-webkit-transform: rotate(-360deg);
		transform: rotate(-360deg);
	}
	}
	@-webkit-keyframes lds-double-ring_reverse {
	0% {
		-webkit-transform: rotate(0);
		transform: rotate(0);
	}
	100% {
		-webkit-transform: rotate(-360deg);
		transform: rotate(-360deg);
	}
	}
	.lds-double-ring {
		position: relative;
	}
	.lds-double-ring div {
		position: absolute;
		width: 80px;
		height: 80px;
		top: 10px;
		left: 10px;
		border-radius: 50%;
		border: 2px solid #000;
		border-color: <?php echo esc_html( $main_color ); ?> transparent <?php echo esc_html( $main_color ); ?> transparent;
		-webkit-animation: lds-double-ring 1.3s linear infinite;
		animation: lds-double-ring 1.3s linear infinite;
	}

	.lds-double-ring div:nth-child(2) {
		width: 70px;
		height: 70px;
		top: 15px;
		left: 15px;
		border-color: transparent #ffffff transparent #ffffff;
		-webkit-animation: lds-double-ring_reverse 1.3s linear infinite;
		animation: lds-double-ring_reverse 1.3s linear infinite;
	}
	.lds-double-ring {
		width: 100px !important;
		height: 100px !important;
		-webkit-transform: translate(-50px, -50px) scale(1) translate(50px, 50px);
		transform: translate(-50px, -50px) scale(1) translate(50px, 50px);
	}

</style>

