<?php
/**
 * Iframe video rendering.
 *
 * @package ctpl\classes
 */

/**
 * Try to get wp-load.php file uri.
 *
 * @return string The wp-load.php file uri, empty string if not found.
 */
function ctpl_get_wpload_uri() {
	if ( isset( $_SERVER['SCRIPT_FILENAME'] ) ) {
		$parse_uri = explode( '/plugins', str_replace( '\\', '/', $_SERVER['SCRIPT_FILENAME'] ) );
		if ( file_exists( dirname( $parse_uri[0] ) . '/wp-load.php' ) ) {
			return dirname( $parse_uri[0] ) . '/wp-load.php';
		}
	}

	if ( isset( $_SERVER['DOCUMENT_ROOT'] ) ) {
		$root_paths = array( $_SERVER['DOCUMENT_ROOT'], '/wordpress', '/wp' );
		foreach ( $root_paths as $root_path ) {
			$it = new RecursiveDirectoryIterator( $root_path );
			foreach ( new RecursiveIteratorIterator( $it ) as $file_path ) {
				if ( false !== strpos( $file_path, 'wp-load.php' ) ) {
					return $file_path;
				}
			}
		}
	}

	return '';
}

try {
	if ( ! isset( $_GET['q'] ) ) {
		throw new Exception( 'Missing q params' );
	}

	$wpload_uri = ctpl_get_wpload_uri();
	if ( ! file_exists( $wpload_uri ) ) {
		throw new Exception( 'wp-load.php not found' );
	}
	require_once $wpload_uri;

	define( 'WP_USE_THEMES', false );

	parse_str( base64_decode( sanitize_text_field( wp_unslash( $_GET['q'] ) ) ), $params );

	if ( ! isset( $params['post_id'] ) ) {
		$params['post_id'] = 0;
	}
	if ( ! isset( $params['type'] ) ) {
		return;
	}
	if ( ! isset( $params['tag'] ) ) {
		return;
	}

	?>
	<html>
	<head>
		<meta name="robots" content="noindex">
		<base target="_parent" />
		<?php require_once CTPL_DIR . 'public/dynamic-style-x.php'; ?>
		<style>
			body {
				color: white;
				background: #000;
				position: absolute;
				margin: 0px;
				height: 100%;
				width: 100%;
			}

			.wps-iframe-loader {
				position: absolute;
				top:0;
				display: flex;
				justify-content: center;
				width: 100%;
				height:100%;
				background: rgb(0,0,0);
				z-index: 5;
			}

			.wps-iframe-loader--inner-block {
				position: absolute;
				top: calc(50% - 60px);
				display: flex;
				flex-direction: column;
				align-self: center;
				justify-self: center;
				text-align: center;
				color: #777;
			}

			.vast_video_loading {
				position: absolute;
			}
		</style>
	</head>
	<body>
	<?php
	$loading_video_text = xbox_get_field_value( 'ctpl-options', 'ctpl-loading-video-text' );
	if ( empty( $loading_video_text ) ) {
		$loading_video_text = 'Loading video';
	}
	?>

		<div class="wps-iframe-loader">
			<div class="wps-iframe-loader--inner-block">
				<div style="width:100%;height:100%" class="wps-iframe-loader--icon lds-double-ring"><div></div><div></div></div>
				<span class="wps-iframe-loader--text"><?php echo esc_html( $loading_video_text ); ?></span>
			</div>
		</div>

	<?php
	$dom_tag  = stripslashes( $params['tag'] );
	$postid   = intval( $params['post_id'] );
	$is_video = false;

	if ( 'video' === $params['type'] ) {
		$ctpl_tag = new CTPL\Video( $dom_tag, $postid );
		$is_video = true;
	} else {
		$ctpl_tag = new CTPL\Iframe( $dom_tag, $postid );
		if ( $ctpl_tag->is_transformable() ) {
			$tube_source = $ctpl_tag->get_tube_source();
			$video_tag   = $ctpl_tag->to_mp4();
			if ( false !== $video_tag ) {
				$ctpl_tag = new CTPL\Video( $video_tag, $postid );
				$is_video = true;
			}
		}
	}
	echo $ctpl_tag->render_player();
	if ( $is_video && $ctpl_tag->is_hls() ) {
		echo '<script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>';
	}

	$ctpl_player_css_version = CTPL_VERSION . '.' . filemtime( esc_url( plugin_dir_path( __FILE__ ) . 'assets/css/ctpl-player.css' ) );
	?>
		<link rel="stylesheet" href="<?php echo esc_url( plugin_dir_url( __FILE__ ) . 'assets/css/ctpl-player.css?ver=' . $ctpl_player_css_version ); ?>">
		<script src="<?php echo esc_url( plugin_dir_url( __FILE__ ) ); ?>vendors/jquery-3.4.1.slim.min.js?ver=3.4.1"></script>
		<script src="<?php echo esc_url( plugin_dir_url( __FILE__ ) ); ?>vendors/fluidplayer-3.0.4.min.js?ver=3.0.4"></script>

		<script type="text/javascript">
		jQuery(document).ready(function() {
			var vastTimeout = 10000;
			var _videoId = 'video';
			var _$video = jQuery('#' + _videoId);

			_$video.on('mouseover', function() {
				jQuery(this).css('cursor', 'auto');
			});

			/** On button click click. Close ad + play video if exists.*/
			jQuery("body").on("click", ".wps-player__happy-inside-btn-close", function() {
				var $happyInsidePlayer = jQuery(".wps-player__happy-inside");
				$happyInsidePlayer.hide(300);
				var $video = jQuery('#' + _videoId)[0];
				if (undefined !== $video) {
					$video.play();
				}
			});

			if (0 !== _$video.length) {
				setupFluidPlayer(_videoId, _$video);
			}

			/**
			 * Setup fluidPlayer
			 *
			 * @param string videoId
			 */
			function setupFluidPlayer(videoId, $video) {
				var ctplOptions = {
					primaryColor: "<?php echo esc_html( xbox_get_field_value( 'ctpl-options', 'main-color' ) ); ?>",
					autoPlay: 'on' === "<?php echo esc_html( xbox_get_field_value( 'ctpl-options', 'vp-autoplay' ) ); ?>",
					allowDownload: 'on' === "<?php echo esc_html( xbox_get_field_value( 'ctpl-options', 'vp-download' ) ); ?>" && '' === "<?php echo esc_html( $is_video && $ctpl_tag->is_hls() ); ?>",
					preRoll: "<?php echo trim( xbox_get_field_value( 'ctpl-options', 'vp-pre-roll-url' ) ); ?>",
					midRoll: "<?php echo trim( xbox_get_field_value( 'ctpl-options', 'vp-mid-roll-url' ) ); ?>",
					midRollTimer: "<?php echo esc_html( xbox_get_field_value( 'ctpl-options', 'vp-mid-roll-timer' ) ); ?>"
				};

				/** Add basic fluidPlayer options dynamically.*/
				var fluidPlayerOptions = {
					layoutControls: {
						fillToContainer: true,
						primaryColor: ctplOptions.primaryColor,
						posterImage: $video.attr( 'poster' ),
						autoPlay: ctplOptions.autoPlay,
						playButtonShowing: true,
						playPauseAnimation: true,
						mute: false,
						keyboardControl: true,
						allowDownload: ctplOptions.allowDownload,
						allowTheatre: false,
						playbackRateEnabled: true,
						controlBar: {
							autoHide: true,
							autoHideTimeout: 3,
							animated: true
						},
						playerInitCallback: ( function() {
							jQuery( '.wps-player__happy-inside--start' ).show(300);
						})
					}
				};

				/** Add vast List options dynamically.*/
				var vastListArray = [];
				if (ctplOptions.preRoll) {
					vastListArray.push({
						"roll": "preRoll",
						"vastTag": ctplOptions.preRoll
					});
				}
				if (ctplOptions.midRoll && ctplOptions.midRollTimer) {
					vastListArray.push({
						"roll": "midRoll",
						"vastTag": ctplOptions.midRoll,
						"timer": ctplOptions.midRollTimer + '%'
					});
				}
				var inVast = false;
				if (vastListArray) {
					fluidPlayerOptions.vastOptions = {
						vastTimeout: vastTimeout,
						adList: vastListArray
					};
				}
				/** FluidPlayer Init.*/
				var videoPlayer = fluidPlayer(videoId, fluidPlayerOptions);

				/** FluidPlayer On pause event.*/
				videoPlayer.on("pause", function() {
					if ( inVast ) {
						return;
					}
					$video.addClass('paused');
					$video.parents('.wps-player').addClass('paused').find(".wps-player__happy-inside--pause").show(300);
				});

				/** FluidPlayer On play event.*/
				videoPlayer.on("play", function() {
					$video.removeClass('paused');
					$video.parents('.wps-player').removeClass('paused').find(".wps-player__happy-inside--start").hide(300);
				});
			}
		});
		</script>
	</body>
	</html>
	<?php
} catch ( Exception $exception ) {
	echo "Caught Exception: {$exception->getMessage()} (code: {$exception->getCode()})";
	WPSCORE()->write_log( 'error', $exception->getMessage() . ' <code>' . $exception->getCode() . '</code>', $exception->getFile(), $exception->getLine() );
}

