/* eslint-disable no-unused-vars, radix */
// eslint-disable-next-line no-use-before-define
// eslint-disable-next-line camelcase

'use strict';

window.PCLL_options = window.PCLL_options || {};

var PCLL = ( function() {
	var PCLL = {

		_lastCheckTs: 0,
		_checkDebounceTimeoutRunning: false,
		_earlyLoadedCount: 0,

		init: function () {
			PCLL.threshold = PCLL.getOptionIntValue('threshold', 200);
			PCLL.recheckDelay = PCLL.getOptionIntValue('recheck_delay', 250);
			PCLL.debounce = PCLL.getOptionIntValue('debounce', 50);
			PCLL.immediateLoadCount = PCLL.getOptionIntValue('immediate_load_count', 3)
			PCLL.checkRecurring();
			PCLL.lazyLoadYouTube();
			return PCLL;
		},

		check: function( fromDebounceTimeout ) {
			var tstamp, winH, updated, els;
			if ( true === fromDebounceTimeout ) {
				PCLL._checkDebounceTimeoutRunning = false;
			}
			tstamp = performance.now();
			if ( tstamp < PCLL._lastCheckTs + PCLL.debounce ) {
				if ( ! PCLL._checkDebounceTimeoutRunning ) {
					PCLL._checkDebounceTimeoutRunning = true;
					setTimeout( function() {
						PCLL.check( true );
					}, PCLL.debounce );
				}
				return;
			}
			PCLL._lastCheckTs = tstamp;

			winH = document.documentElement.clientHeight || body.clientHeight;
			updated = false;
			els = document.getElementsByClassName( 'lazy-hidden' );

			[].forEach.call( els, function( el, index, array ) {
				var elemRect = el.getBoundingClientRect();

				// do not lazy-load images that are hidden with display:none or have a width/height of 0
				if ( ! elemRect.width || ! elemRect.height ) {
					return;
				}

				// directly load the first nth images
				if (PCLL._earlyLoadedCount <= PCLL.immediateLoadCount) {
					PCLL._earlyLoadedCount++;
					PCLL.showImmediately( el );
				}

				if ( 0 < winH - elemRect.top + PCLL.threshold ) {
					PCLL.show( el );
					updated = true;
				}
			});

			if ( updated ) {
				PCLL.check();
			}
		},

		checkRecurring: function() {
			PCLL.check();
			setTimeout( PCLL.checkRecurring, PCLL.recheckDelay );
		},

		show: function( el ) {
			var type, s, div, iframe;
			el.className = el.className.replace( /(?:^|\s)lazy-hidden(?!\S)/g, '' );
			el.addEventListener( 'load', function() {
				el.className += ' lazy-loaded';
				PCLL.customEvent( el, 'lazyloaded' );
			}, false );

			type = el.getAttribute( 'data-lazy-type' );

			if ( 'image' == type ) {
				if ( null != el.getAttribute( 'data-lazy-srcset' ) ) {
					el.setAttribute( 'srcset', el.getAttribute( 'data-lazy-srcset' ) );
				}
				if ( null != el.getAttribute( 'data-lazy-sizes' ) ) {
					el.setAttribute( 'sizes', el.getAttribute( 'data-lazy-sizes' ) );
				}
				el.setAttribute( 'src', el.getAttribute( 'data-lazy-src' ) );
			} else if ( 'iframe' == type ) {
				s = el.getAttribute( 'data-lazy-src' );
				div = document.createElement( 'div' );

				div.innerHTML = s;
				iframe = div.firstChild;
				el.parentNode.replaceChild( iframe, el );
			}
		},

		showImmediately: function( el ) {
			// This function is similar to the "show" function but without lazy loading
			var type, s, div, iframe;
			el.className = el.className.replace( /(?:^|\s)lazy-hidden(?!\S)/g, '' );
			el.addEventListener( 'load', function() {
				el.className += ' lazy-load-direct';
				PCLL.customEvent( el, 'lazyloaded' );
			}, false );

			type = el.getAttribute( 'data-lazy-type' );

			if ( 'image' == type ) {
				if ( null != el.getAttribute( 'data-lazy-srcset' ) ) {
					el.setAttribute( 'srcset', el.getAttribute( 'data-lazy-srcset' ) );
				}
				if ( null != el.getAttribute( 'data-lazy-sizes' ) ) {
					el.setAttribute( 'sizes', el.getAttribute( 'data-lazy-sizes' ) );
				}
				el.setAttribute( 'src', el.getAttribute( 'data-lazy-src' ) );
			} else if ( 'iframe' == type ) {
				s = el.getAttribute( 'data-lazy-src' );
				div = document.createElement( 'div' );

				div.innerHTML = s;
				iframe = div.firstChild;
				el.parentNode.replaceChild( iframe, el );
			}
		},

		customEvent: function( el, eventName ) {
			var event;

			if ( document.createEvent ) {
				event = document.createEvent( 'HTMLEvents' );
				event.initEvent( eventName, true, true );
			} else {
				event = document.createEventObject();
				event.eventType = eventName;
			}

			event.eventName = eventName;

			if ( document.createEvent ) {
				el.dispatchEvent( event );
			} else {
				el.fireEvent( 'on' + event.eventType, event );
			}
		},

		lazyLoadYouTube: function (el) {
			var lazyloadYoutube = document.querySelectorAll('.pcll-youtube-player');

			lazyloadYoutube.forEach(function (div) {
				div.addEventListener('click', function () {
					var iframe = document.createElement('iframe');
					iframe.setAttribute('frameborder', '0');
					iframe.setAttribute('allowfullscreen', '');
					iframe.setAttribute('allow', 'autoplay'); // Explicitly allow autoplay

					// Construct the iframe src with autoplay and feature parameters
					var baseSrc = this.getAttribute('data-src');
					var separator = baseSrc.includes('?') ? '&' : '?'; // Determine the correct separator
					var videoSrc = `${baseSrc}${separator}autoplay=1&feature=oembed`; // Append autoplay=1 and feature=oembed

					iframe.setAttribute('src', videoSrc);
					iframe.style.width = '100%';
					iframe.style.height = this.offsetHeight + 'px';
					this.innerHTML = '';
					this.appendChild(iframe);
				});
			});
		},

		getOptionIntValue: function( name, defaultValue ) {
			// eslint-disable-next-line camelcase
			if ( 'undefined' !== typeof ( window.PCLL_options[name]) ) {
				// eslint-disable-next-line camelcase
				return parseInt( window.PCLL_options[name]);
			}
			return defaultValue;
		}
	};
	return PCLL.init();
}() );

window.addEventListener( 'load', PCLL.check, false );
window.addEventListener( 'scroll', PCLL.check, false );
window.addEventListener( 'resize', PCLL.check, false );
document.getElementsByTagName( 'body' ).item( 0 ).addEventListener( 'post-load', PCLL.check, false );
