<?php
	add_filter(
		'theme_mod_seo_video_title',
		function ( $value ) {
			$video_title = get_the_title();
			$value       = str_replace( '%%video_title%%', $video_title, $value );
			return $value;
		}
	);
	add_filter(
		'theme_mod_seo_video_tracking_button',
		function ( $value ) {
			$video_title = get_the_title();
			$value       = str_replace( '%%video_title%%', $video_title, $value );
			return $value;
		}
	);
	$video_title        = get_the_title();
	$video_tracking_url = get_post_meta( $post->ID, 'tracking_url', true );
	if ( has_post_thumbnail() ) {
		$video_thumb_url = get_the_post_thumbnail_url( get_the_id(), 'video-thumb' );
	} else {
		$video_thumb_url = get_post_meta( get_the_ID(), 'thumb', true );
	}

	// Above related videos Ads.
	$ads = array(
		'under_player'              => wpst_render_shortcodes( get_theme_mod( 'ads_single_video_page_under_player', '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>' ) ),
		'before_related_videos_ads' => wpst_render_shortcodes( get_theme_mod( 'ads_single_video_page_before_related_videos', '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>' ) ),
		'beside_player_1'           => wpst_render_shortcodes( get_theme_mod( 'ads_single_video_page_beside_player_1', '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>' ) ),
		'beside_player_2'           => wpst_render_shortcodes( get_theme_mod( 'ads_single_video_page_beside_player_2', '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>' ) ),
	);

	$has_wpst_beside_player_ad_zone_desktop = $ads['beside_player_1'] || $ads['beside_player_2']; ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemprop="video" itemscope itemtype="http://schema.org/VideoObject">
	<section class="single-video-player">
		<div class="container">
			<div class="row">
				<?php if ( $has_wpst_beside_player_ad_zone_desktop ) : ?>
					<div class="col-12 col-md-9">
						<?php get_template_part( 'loop-templates/content', 'video-player' ); ?>
						<div class="d-none d-md-block happy-player-under">
							<?php echo $ads['under_player']; ?>
						</div>
					</div>
					<div class="col-12 col-md-3 happy-player-beside">
						<div class="zone-1"><?php echo $ads['beside_player_1']; ?></div>
						<div class="zone-2"><?php echo $ads['beside_player_2']; ?></div>
					</div>
				<?php else : ?>
					<div class="col-12 col-md-10 mx-auto">
						<?php get_template_part( 'loop-templates/content', 'video-player' ); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>

	<section class="single-video-infos">
		<div class="container">
			<div class="row d-flex justify-content-between">
				<div class="col-12 col-md-8 col-left">
					<h1><?php echo get_theme_mod( 'seo_video_title', $video_title ); ?></h1>
					<!-- Description -->
					<?php
					$content          = get_the_content();
					$video_in_content = false;
					$video_code       = array();
					if ( preg_match( '/\[video.+\]/', get_the_content(), $video_code ) ) {
						$video_in_content = '/\[video.+\]/';
					} elseif ( preg_match( '/<iframe.+<\/iframe>/', get_the_content(), $video_code ) ) {
						$video_in_content = '/<iframe.+<\/iframe>/';
					} elseif ( preg_match( '/<video.+<\/video>/', get_the_content(), $video_code ) ) {
						$video_in_content = '/<video.+<\/video>/';
					} elseif ( preg_match( '/<object.+<\/object>/', get_the_content(), $video_code ) ) {
						$video_in_content = '/<object.+<\/object>/';
					} elseif ( preg_match( "/https:\/\/www.youtube.com\/watch\?v=.+?\b/", get_the_content(), $video_code ) ) {
						$video_in_content = "/https:\/\/www.youtube.com\/watch\?v=.+?\b/";
					}
					if ( ! empty( $content ) ) :
						?>
						<div class="video-description">
							<?php
							$embed_code      = get_post_meta( $post->ID, 'embed', true );
							$video_url       = get_post_meta( $post->ID, 'video_url', true );
							$video_shortcode = get_post_meta( $post->ID, 'shortcode', true );
							if ( false !== $video_in_content && ( '' === $embed_code && '' === $video_shortcode && '' === $video_url ) ) {
									$content = preg_replace( $video_in_content, '', get_the_content() );
							}
							echo apply_filters( 'the_content', $content );
							?>
						</div>
					<?php endif; ?>

					<?php
						$postcats = get_the_category();
						$posttags = get_the_tags();
						$actors   = wp_get_post_terms( $post->ID, 'actors' );

					if ( $postcats || $posttags || $actors ) {
						echo '<div class="row tags-list">
									<div class="col-12 col-md-10">
										<div class="list">';
						if ( $postcats !== false ) {
							foreach ( (array) $postcats as $cat ) {
								echo '<a href="' . get_category_link( $cat->term_id ) . '" class="label" title="' . $cat->name . '"><i class="fa fa-folder"></i> ' . $cat->name . '</a>';
							}
						}
						if ( $posttags !== false ) {
							foreach ( (array) $posttags as $tag ) {
												echo '<a href="' . get_tag_link( $tag->term_id ) . '" class="label" title="' . $tag->name . '"><i class="fa fa-tag"></i> ' . $tag->name . '</a>';
							}
						}
						if ( ! empty( $actors ) ) {
							foreach ( (array) $actors as $actor ) {
												echo '<a href="' . get_term_link( $actor->term_id ) . '" class="label" title="' . $actor->name . '"><i class="fa fa-star"></i> ' . $actor->name . '</a>';
							}
						}
									echo '</div></div></div>';
					}
					?>
				</div>
				<div class="col-12 col-md-4">
					<div class="video-actions">
						<div id="video-views" class="video-actions-box"><span class="views-number"><?php echo wpst_getPostViews( get_the_ID() ); ?></span> <span class="views-title"><?php esc_html_e( 'views', 'wpst' ); ?></span></div>
						<div id="video-rate" class="video-actions-box"><?php echo wpst_getPostLikeLink( get_the_ID() ); ?></div>
					</div>
					<?php if ( $video_tracking_url && get_theme_mod( 'enable_video_tracking_link', 'no' ) === 'yes' ) : ?>
						<div class="embed-responsive embed-responsive-16by9 video-tracking">
							<div class="bg-image" style="background-image: url(<?php echo $video_thumb_url; ?>);"></div>
							<div class="bg-gradient"></div>
							<a href="<?php echo $video_tracking_url; ?>" target="_blank" rel="nofollow noreferrer">
								<span class="text"><?php echo get_theme_mod( 'seo_video_tracking_button', 'Download full video now' ); ?></span>
							</a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</section>
	<?php if ( $ads['before_related_videos_ads'] ) : ?>
		<div class="happy-section">
			<?php echo $ads['before_related_videos_ads']; ?>
		</div>
	<?php endif; ?>
</article>

